using System;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;

namespace QuizplusApi.Models.Others
{
    public class BillingPayment
    {
        [Key]
        public int BillingPaymentId{get;set;}
		[StringLength(500)]
        public string Title{get;set;}
        [Required]
        public int Price{get;set;}
		[StringLength(50)]
        public string Interval{get;set;}
        public int AssessmentCount{get;set;}
        public int QuestionPerAssessmentCount{get;set;}
        public int ResponsePerAssessmentCount{get;set;}
        [StringLength(800)]
		public string StripeSessionId { get; set; }
        [StringLength(250)]
		public string UserEmail { get; set; }
        [StringLength(250)]
		public string TransactionEmail { get; set; }
        [StringLength(50)]
		public string PaymentMode { get; set; }
		public string TransactionDetail { get; set; }
        public int? AddedBy{get;set;}
        [Required]
		public DateTime StartDate { get; set; }
        [Required]
		public DateTime EndDate { get; set; }
		[Required]
		public bool IsActive {get;set;}
        [Required]
		public DateTime DateAdded { get; set; }
    }
}